<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vin extends Model 
{

    protected $table = 'vins';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nom', 'taille', 'couleur', 'description', 'id_marque', 'id_type_vin', 'degre', 'age', 'image', 'statut');
    protected $visible = array('nom', 'taille', 'couleur', 'description', 'id_marque', 'id_type_vin', 'degre', 'age', 'image', 'statut');

    public function unites()
    {
        return $this->hasMany('App\Models\Unite', 'id_vin');
    }

    public function marque()
    {
        return $this->belongsTo('App\Models\Marque', 'id_marque');
    }

    public function type_vin()
    {
        return $this->belongsTo('App\Models\Type_vin', 'id_type_vin');
    }

    public function prix()
    {
        return $this->hasMany('App\Models\Prix', 'id_vin');
    }

}